/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info.projectile;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.dispenser.DispenserBehaviorBase;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.CustomProjectileEntity;
import com.lycanitesmobs.core.entity.CustomProjectileModelEntity;
import com.lycanitesmobs.core.helpers.JSONHelper;
import com.lycanitesmobs.core.info.ElementInfo;
import com.lycanitesmobs.core.info.ElementManager;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.info.projectile.behaviours.ProjectileBehaviour;
import com.lycanitesmobs.core.item.ChargeItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.BlockDispenser;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class ProjectileInfo {
    protected String name;
    public Class<? extends Entity> entityClass = CustomProjectileEntity.class;
    public String modelClassName;
    public ModInfo modInfo;
    public Item chargeItem;
    public String chargeItemName;
    public boolean noChargeItem = false;
    public DispenserBehaviorBase dispenserBehaviour;
    public float width = 0.75f;
    public float height = 0.75f;
    public float scale = 0.5f;
    public int lifetime = 200;
    public int damage = 1;
    public int pierce = 1;
    public double knockbackChance = 0.0;
    public int effectDuration = 1;
    public int effectAmplifier = 1;
    public double velocity = 1.1;
    public double weight = 1.0;
    public float rollSpeed = 0.0f;
    public List<ElementInfo> elements = new ArrayList<ElementInfo>();
    public List<ProjectileBehaviour> behaviours = new ArrayList<ProjectileBehaviour>();
    public boolean waterproof = false;
    public boolean lavaproof = false;
    public boolean cutGrass = false;
    public boolean ripper = false;
    public boolean pierceBlocks = false;
    public boolean impactSound = false;
    public int animationFrames = 1;
    public boolean glow = false;
    public boolean burningEffect = false;
    public int particleCount = 0;
    public EnumParticleTypes particleType = null;
    public EnumParticleTypes waterParticleType = null;

    public ProjectileInfo(ModInfo modInfo) {
        this.modInfo = modInfo;
    }

    public void loadFromJSON(JsonObject json) {
        this.name = json.get("name").getAsString();
        this.chargeItemName = json.has("chargeItemName") ? json.get("chargeItemName").getAsString() : this.name + "charge";
        if (json.has("noChargeItem")) {
            this.noChargeItem = json.get("noChargeItem").getAsBoolean();
        }
        if (json.has("entityClass")) {
            try {
                this.entityClass = Class.forName(json.get("entityClass").getAsString());
            }
            catch (Exception e) {
                LycanitesMobs.logWarning("", "[Projectile] Unable to find the Java Entity Class: " + json.get("entityClass").getAsString() + " for " + this.getName());
            }
        }
        if (json.has("modelClass")) {
            this.modelClassName = json.get("modelClass").getAsString();
        }
        if (json.has("width")) {
            this.width = json.get("width").getAsFloat();
        }
        if (json.has("height")) {
            this.height = json.get("height").getAsFloat();
        }
        if (json.has("scale")) {
            this.scale = json.get("scale").getAsFloat();
        }
        if (json.has("damage")) {
            this.damage = json.get("damage").getAsInt();
        }
        if (json.has("pierce")) {
            this.pierce = json.get("pierce").getAsInt();
        }
        if (json.has("knockbackChance")) {
            this.knockbackChance = json.get("knockbackChance").getAsDouble();
        }
        if (json.has("effectDuration")) {
            this.effectDuration = json.get("effectDuration").getAsInt();
        }
        if (json.has("effectAmplifier")) {
            this.effectAmplifier = json.get("effectAmplifier").getAsInt();
        }
        if (json.has("velocity")) {
            this.velocity = json.get("velocity").getAsDouble();
        }
        if (json.has("weight")) {
            this.weight = json.get("weight").getAsDouble();
        }
        if (json.has("lifetime")) {
            this.lifetime = json.get("lifetime").getAsInt();
        }
        List<Object> elementNames = new ArrayList();
        if (json.has("elements")) {
            elementNames = JSONHelper.getJsonStrings(json.get("elements").getAsJsonArray());
        }
        this.elements.clear();
        for (String elementName : elementNames) {
            ElementInfo element = ElementManager.getInstance().getElement(elementName);
            if (element == null) {
                throw new RuntimeException("[Creature] Unable to initialise Projectile Info for " + this.getName() + " as the element " + elementName + " cannot be found.");
            }
            this.elements.add(element);
        }
        if (json.has("behaviours")) {
            JsonArray jsonArray = json.get("behaviours").getAsJsonArray();
            Iterator jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                JsonObject behaviorJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                ProjectileBehaviour projectileBehaviour = ProjectileBehaviour.createFromJSON(behaviorJson);
                if (projectileBehaviour != null) {
                    this.behaviours.add(projectileBehaviour);
                    continue;
                }
                LycanitesMobs.logWarning("", "Unable to load Projectile Behaviour: " + behaviorJson.get("type").getAsString());
            }
        }
        if (json.has("waterproof")) {
            this.waterproof = json.get("waterproof").getAsBoolean();
        }
        if (json.has("lavaproof")) {
            this.lavaproof = json.get("lavaproof").getAsBoolean();
        }
        if (json.has("cutGrass")) {
            this.cutGrass = json.get("cutGrass").getAsBoolean();
        }
        if (json.has("ripper")) {
            this.ripper = json.get("ripper").getAsBoolean();
        }
        if (json.has("pierceBlocks")) {
            this.pierceBlocks = json.get("pierceBlocks").getAsBoolean();
        }
        if (json.has("impactSound")) {
            this.impactSound = json.get("impactSound").getAsBoolean();
        }
        if (json.has("animationFrames")) {
            this.animationFrames = json.get("animationFrames").getAsInt();
        }
        if (json.has("glow")) {
            this.glow = json.get("glow").getAsBoolean();
        }
        if (json.has("burningEffect")) {
            this.burningEffect = json.get("burningEffect").getAsBoolean();
        }
        if (json.has("particleCount")) {
            this.particleCount = json.get("particleCount").getAsInt();
        }
        if (json.has("particleType")) {
            String particleTypeName = json.get("particleType").getAsString();
            this.particleType = EnumParticleTypes.func_186831_a((String)particleTypeName);
        }
        if (json.has("waterParticleType")) {
            String waterParticleTypeName = json.get("waterParticleType").getAsString();
            this.waterParticleType = EnumParticleTypes.func_186831_a((String)waterParticleTypeName);
        }
    }

    public void load() {
        if (!this.noChargeItem) {
            this.chargeItem = ObjectManager.getItem(this.chargeItemName);
            if (this.chargeItem == null) {
                this.chargeItem = new ChargeItem(this);
                ObjectManager.addItem(this.chargeItemName, this.chargeItem);
            }
            this.dispenserBehaviour = new DispenserBehaviorBase(this);
            BlockDispenser.field_149943_a.func_82595_a((Object)this.chargeItem, (Object)this.dispenserBehaviour);
        }
        AssetManager.addSound(this.name, this.modInfo, "projectile." + this.name);
        if (this.impactSound) {
            AssetManager.addSound(this.name + "_impact", this.modInfo, "projectile." + this.name + ".impact");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getEntityId() {
        return this.modInfo.modid + ":" + this.getName();
    }

    public ResourceLocation getResourceLocation() {
        return new ResourceLocation(this.modInfo.modid, this.getName());
    }

    public String getLocalisationKey() {
        return this.getName();
    }

    public String getTitle() {
        return LanguageManager.translate("entity." + this.getLocalisationKey());
    }

    public BaseProjectileEntity createProjectile(World world, EntityLivingBase entityLivingBase) {
        if (this.modelClassName != null) {
            return new CustomProjectileModelEntity(world, entityLivingBase, this);
        }
        return new CustomProjectileEntity(world, entityLivingBase, this);
    }

    public BaseProjectileEntity createProjectile(World world, double x, double y, double z) {
        if (this.modelClassName != null) {
            return new CustomProjectileModelEntity(world, x, y, z, this);
        }
        return new CustomProjectileEntity(world, x, y, z, this);
    }

    public SoundEvent getLaunchSound() {
        return AssetManager.getSound(this.name);
    }

    public SoundEvent getImpactSound() {
        return AssetManager.getSound(this.name + "_impact");
    }
}

